;  Version 3.3
; Scripts for Outlook Express 
; Copyright 1998 by Henter-Joyce, Inc.
; 9/29/98, A.Gonzalez.

include "msimnui.jsh"
include "msimnui.jsm"
Include "hjconst.jsh"
Include "hjglobal.jsh"
use "magOExp.jsb"

Function AutoFinishEvent ()
;var
;	object null
;let ieCurrentDocument = null
TurnSuppressCheckForBoldOff ()
EndFunction

Script ScriptFileName ()
ScriptAndAppNames ("Outlook Express ")
EndScript

Script GotoAttachmentsList ()
var
	handle winHandle
let winHandle = GetAppMainWindow (GetFocus ());
if (GetWindowClass (winHandle) != wc_message) then
; not in an open message 
	Say(msg_NoOpenMessage, ot_message);
	return;
EndIf
let winHandle = FindDescendantWindow (winHandle, attachments_list)
if (winHandle && IsWindowVisible (winHandle)) then
	FocusWindow (winHandle)
else
	Say(msg_NoAttachments, ot_message);
EndIf
EndScript

Script GoToMessageField ()
var
	handle winHandle
let winHandle = GetAppMainWindow (GetFocus ())
if (GetWindowClass (winHandle) != wc_message) then
; not in an open message 
	Say(msg_NoOpenMessage, ot_message);
	return;
EndIf
let winHandle = GetFirstChild (winHandle);
while (winHandle &&
	(GetWindowClass (winHandle) != wc_BodyHost))
	let winHandle = GetNextWindow (winHandle);
EndWhile
let winHandle = GetFirstChild (winHandle);
while (winHandle &&
	(GetWindowClass (winHandle) != wc_message_body))
	let winHandle = GetNextWindow (winHandle);
EndWhile
if winHandle then
	SaveCursor ();
	JawsCursor ();
	MoveToWindow (WinHandle);
	pause ();
	LeftMouseButton ();
	RestoreCursor ();
else
	Say(msg_NoOpenMessage, ot_message);
EndIf
EndScript

HANDLE Function GetHeaderWindow ()
return FindDescendantWindow (GetAppMainWindow (GetFocus ()), message_header);
EndFunction

HANDLE Function GetHeaderControl (int cId)
return FindDescendantWindow (GetHeaderWindow (), cId)
EndFunction

Function FocusWindow (handle hwnd)
var
	int subTypeCode
SaveCursor ()
JawsCursor ()
MoveToWindow (hwnd)
pause ()
LeftMouseButton ()
let subTypeCode = GetWindowSubTypeCode (hwnd) 
if ((subTypeCode == wt_combobox) || 
	(subTypeCode == wt_checkbox)) then
	LeftMouseButton ()
EndIf
RestoreCursor ()
EndFunction

Void Function ReadHeaderControl (int controlId)
var
	handle winHandle
let winHandle = GetHeaderControl (controlId)
if (winHandle && IsWindowVisible (winHandle)) then
	if IsSameScript () then
		FocusWindow (winHandle)
		return
	EndIf
	ReadPrompt (controlId)
	if (GetWindowSubTypeCode (winHandle) == wt_checkbox) then
		SayWindowTypeAndText (winHandle)
	else
		SayWindow (winHandle, read_everything)
	EndIf
	if (GetVerbosity () == beginner) then
		Say(msg1, ot_message); " Press twice to edit "
	EndIf
else
	ControlNotFound (controlId)
EndIf
EndFunction

Function ReadPrompt (int cId)
var
	handle hwnd
let hwnd = GetHeaderControl (cId);
if hwnd then
	SaveCursor ();
	InvisibleCursor ();
	MoveToWindow (hwnd);
	JawsHome ();
	SayWord ();
	RestoreCursor ();
EndIf
EndFunction

Function ControlNotFound (int cId)
var
	string str
if (cId == from_field) ||
(cId == From_Field4) then
	let str = msg_from;
elif (cId == date_field) then
	let str = msg_date;
elif (cId == to_field) then
	let str = msg_to;
elif (cId == cc_field) then
	let str = msg_cc;
elif (cId == bcc_field) then
	let str = msg_bcc;
elif (cId == subject_field) then
	let str = msg_subject;
EndIf
let str = str + msg_FieldNotFound;
Say(str, ot_buffer);
EndFunction

Script ReadFromField ()
ReadHeaderControl (from_field4);
EndScript

Script ReadDateField ()
ReadHeaderControl (date_field);
EndScript

Script ReadToField ()
ReadHeaderControl (to_field);
EndScript

Script ReadCcField ()
ReadHeaderControl (cc_field);
EndScript

Script ReadBccField ()
ReadHeaderControl (Bcc_field);
EndScript

Script ReadSubjectField ()
ReadHeaderControl (subject_field);
EndScript

Function FocusChangedEvent (handle focusWindow, handle prevWindow)
; The default FocusChangedEvent function has been modified to smooth going back and forth from the app 
; to the JAWS Select Item in List dialog
var
	handle RealWindow,
	string RealWindowName,
	handle AppWindow
let RealWindow = GetRealWindow(FocusWindow)
let RealWindowName = GetWindowName (RealWindow)
let AppWindow = GetAppMainWindow(FocusWindow)
if (GlobalPrevApp != AppWindow
   && AppWindow != FocusWindow) then 
	; we've switched to a different app main window, 
	; and it does not have the focus, so announce it
	; but first check that you are not moving between the app and the JAWS Select Item dialog
	if (GetWindowClass (GlobalPrevApp) == wc_JAWS) then
		let GlobalFocusWindow = FocusWindow
		let GlobalPrevReal = RealWindow
		let GlobalPrevRealName = RealWindowName
		let GlobalPrevApp = AppWindow
		let GlobalPrevFocus = FocusWindow
		return
	EndIf
	if (GetWindowClass (appWindow) != wc_JAWS) then
		SayWindowTypeAndText(AppWindow)
	EndIf
endif
If ((GlobalPrevRealName != RealWindowName) ; name has changed
   || (GlobalPrevReal != RealWindow)) then ; or handle has changed, then
	If ((RealWindow != AppWindow)
	   && (RealWindow != FocusWindow)) then
		SayWindowTypeAndText(RealWindow)
	endif
EndIf
let GlobalFocusWindow = FocusWindow
if (GlobalPrevFocus != focusWindow) then
	SayFocusedWindow () ; will use global variable GlobalFocusWindow
else
	SayFocusedObject ()
EndIf
;above perform will return here to finish this routine
;now set all the global variables for next time.
let GlobalPrevReal = RealWindow
let GlobalPrevRealName = RealWindowName
let GlobalPrevApp = AppWindow
let GlobalPrevFocus = FocusWindow
EndFunction

Function SayFocusedWindow ()
var
	string theClass,
	int controlId
let theClass = GetWindowClass (globalFocusWindow);
if (theClass == ie4Class) then
	if CaretVisible () then
		Say(msg31, ot_control_name); "Edit "
		return
	EndIf
	SayWindow (globalFocusWindow, read_everything)
	return
EndIf
let controlId = GetControlId (globalFocusWindow);
if (controlId == ChangeTo_field) then
	if (GetWindowName (GetParent (GlobalFocusWindow)) == "Spelling") then
		PerformScript ReadMisspelledAndSuggestion ()
		return
	EndIf
EndIf
if ((controlId == attachments_list) &&
	(GetWindowSubTypeCode (globalFocusWindow) == wt_listview)) then
	Say(msg_attachments, ot_message)
EndIf
SayFocusedObject ()
EndFunction

Void Function NewTextEvent (handle hwnd, string buffer, int nAttributes, 
int nTextColor, int nBackgroundColor, int nEcho, string sFrameName)
; Handles all newly written text.  If the text is contained in a
; frame, then the frame name is passed as a parameter
if (ProcessSelectText(nAttributes,buffer)) then
	return
endif
if (sFrameName == "") then
	; this text is not associated with a frame
	if (nAttributes& ATTRIB_HIGHLIGHT) then
		SayHighlightedText(hwnd,buffer, nAttributes)
	else
		SayNonHighlightedText(hwnd,buffer)
	endif
else
	; this text is associated with a frame
	if (nEcho == ECHO_NONE) then
		return; frame is being silenced
	endif
	if (nEcho  == ECHO_ALL ||
	   (nAttributes & ATTRIB_HIGHLIGHT)) then
		; if FrameEcho is set to all or the text being written is highlighted
		Say(buffer, ot_buffer)
	endif
endif
EndFunction

Void Function TurnSuppressCheckforBoldOff ()
let scheduledFunctionId = 0
let nSuppressCheckForBold = false
EndFunction

Function SayHighlightedText (handle hwnd, string buffer, int nattributes)
var
	int controlId
let controlId = GetControlId (hwnd);
if IsMessagesList (hwnd) then
	if !nSuppressCheckForBold then
	;the nSuppressCheckForBold is used here to avoid repetition of "unread message" message
	;the ScheduleFuction is used to set a timer to turn this global back to off
		if (nAttributes & attrib_bold) then
			Say(msg_UnreadMessage, ot_message);
			let nSuppressCheckForBold = true;
			if scheduledFunctionId then
				UnScheduleFunction (scheduledFunctionId)
			EndIf
			let scheduledFunctionId = ScheduleFunction ("TurnSuppressCheckForBoldOff", 2)
		EndIf
	EndIf
EndIf
if (controlId == ChangeTo_field) then
	if (GetWindowName (GetParent (GlobalFocusWindow)) == "Spelling") then
		PerformScript ReadMisspelledAndSuggestion ()
		return
	EndIf
EndIf
if ((GetScreenEcho() > 0) && !nSuppressEcho) Then
	Say(buffer, ot_buffer)
EndIf
EndFunction

Void Function SayNonHighlightedText (handle hwnd, string buffer)
var
	string TheClass
if (nSuppressEcho) then
	return
EndIf
let TheClass = GetWindowClass(hwnd)
if (TheClass == ie4Class) then
	if (GetWindowClass (GetFocus ()) == ie4Class) then
		if (globalMenuMode == menu_inactive) then
			if !CaretVisible () then
				Say(buffer, ot_buffer)
				return
			EndIf
		EndIf
	EndIf
EndIf
if ((GetScreenEcho() > 1)
	|| (TheClass == "#32771")) then
	Say(buffer, ot_buffer)
EndIf
EndFunction

Script ReadCurrentScreen ()
MoveToWindow (GetFocus())
RestrictCursor (on)
SayAll ()
RestrictCursor (Off)
EndScript

Script ReadNextScreen ()
let nSuppressEcho = TRUE
PCCursor ()
JawsPageDown ()
Delay (2)
let nSuppressEcho = FALSE
PerformScript ReadCurrentScreen()
EndScript

Script ReadPriorScreen ()
let nSuppressEcho = TRUE
PCCursor ()
JawsPageUp ()
Delay (2)
let nSuppressEcho = FALSE
PerformScript ReadCurrentScreen()
EndScript

Void Function MoveToLink (int nNext)
var
int bNeedToSuppressEcho
if  (GetWindowClass(GetFocus()) == ie4Class) then
let bNeedToSuppressEcho = TRUE
endif
; 1 = next, 0 = previous
if (nNext > 0) then
	{Tab}
else
	{Shift+Tab}
EndIf
if (bNeedToSuppressEcho) then
let nSuppressEcho = true ; to avoid chattering caused by SayNonHighlightedText
pause ()
let nSuppressEcho = false
EndIf
EndFunction

Script MoveToNextLink()
MoveToLink(1)
EndScript

Script MoveToPriorLink ()
MoveToLink(0)
EndScript

Script SayWindowPromptAndText ()
SayFocusedObject ()
EndScript

Script ReformatDocument ()
if (ieReformatBody(GetFocus())) then
	Say(msg2, ot_message); "Reformatting message "
else
	Say(msg3, ot_message); "Reformatting failed.  Document may not have finished loadingd"
Endif
EndScript

Script SelectALink ()
var
	object doc,
	object links,
	object all,
	int nLinks,
	string buffer,
	string strTemp,
	int nIdx
let doc = ie4GetCurrentDocument ()
let links = doc.links
let all = doc.all
let nLinks = links.length
if (nLinks == 0) then
	Say(msg4, ot_message); "No links found on page "
	return
endif
let nIdx = 0
while (nIdx < nLinks)
	let strTemp = links(nIdx).InnerText
	if (!strTemp) then
		let strTemp = all(links(nIdx).SourceIndex+1).alt
	endif
	if (!strTemp) then
		let strTemp = links(nIdx).href
	endif
	let buffer = buffer + "|" + strTemp
	let nIdx = nIdx+1
endwhile
let nIdx = DlgSelectItemInList (buffer, "Select a Link", true)
if (nIdx == 0) then
	return
endif
doc.links(nIdx-1).click
EndScript

Int Function ieFocusToFirstField ()
var
	object doc,
	object all,
	object forms,
	int nIdx,
	object element,
	string theType
let doc = ie4GetCurrentDocument()
if (!doc) then
	return FALSE
endif
let forms = doc.forms
if (forms.length <= 0 ) then
	return FALSE
endif
let nIdx = forms(0).SourceIndex()
let all = doc.all
while (nIdx < all.length)
	let element = all(nIdx)
	let TheType = element.type
	if (TheType != "" &&
		TheType != "hidden") then
		element.focus
		return TRUE
	endif
	let nIdx = nIdx+1
endwhile
return FALSE
EndFunction

Script FocusToFirstField ()
let nSuppressEcho = TRUE
if (ieFocusToFirstField ()) then
	Beep()
	ProcessNewText()
else
	Say(msg32, ot_message); "Input field not found"
Endif
let nSuppressEcho = FALSE
EndScript

Script ReadMisspelledAndSuggestion ()
var
	handle winHandle
let winHandle = GetParent (GetFocus ())
if (GetWindowName (winHandle) == "Spelling") Then
	if (ToggleRestriction ()) then
		ToggleRestriction () 
	EndIf ; if restriction on
	SaveCursor ()
	InvisibleCursor()
	MoveToControl (winHandle, NotInDictionary_field)
	If (GetVerbosity () > beginner) then
		SayWord ()
	Else
		SayLine ()
	EndIf
	SpellString (GetWord())
	; now see if there are any suggestions
	if MoveToControl (winHandle, suggestions_listbox) then
		if StringContains (GetChunk (), "no suggestions") then
			Say(msg5, ot_message)
		else
			MoveToControl (winHandle, changeTo_field)
			if (GetVerbosity () > beginner) then
				SayWord ()
			else
				SayLine ()
			EndIf ; verbosity
			SpellWord ()
		EndIf ; no suggestions
	EndIf
	RestoreCursor ()
Else
	Say(msg33, ot_message)
EndIf
EndScript

Int Function IsMessagesList (handle hwnd)
if (GetWindowSubtypeCode (hwnd) == wt_listview) then
	if (GetWindowClass (GetParent (hwnd)) == wc_messagesList_parent) then
		return true;
	EndIf
EndIf
return false;
EndFunction

Script HotKeyHelp ()
var
	handle WinHandle,
	string TheClass
let WinHandle = GetFocus ()
let TheClass = GetWindowClass(WinHandle)
if ((TheClass == ie4Class) || 
	(GetWindowClass (GetParent (WinHandle)) == ie4Class)) then
	if (!CaretVisible ()) then
		if (GetVerbosity () == beginner && !GetHelpWindow ()) then
			Say(msg34, ot_help); "you may use the following hot keys when reading a message: "
		EndIf
		Say(msg6 +; "To read the body of the document with the JAWS cursor, use "
		GetScriptKeyName ("ReadCurrentScreen"), ot_help)
		Say(msg7 +; "To scroll the document up and down and read with the JAWS cursor, use "
		GetScriptKeyName ("ReadPriorScreen") + " and " +
		GetScriptKeyName ("readNextScreen") + msg58, ot_help); " respectively "
		Say(msg8 + ; "To move forward and backward through links and other controls, use "
		GetScriptKeyName ("MoveToNextLink") + " and " + 
		GetScriptKeyName ("MoveToPriorLink") + msg58, ot_help) ; " respectively "
		Say(msg9 + ; "To read the selected link or control, use "
		GetScriptKeyName ("SayWindowPromptAndText"), ot_help)
		Say(msg10 +; "To select a link from a list of all the links contained in the document, use "
		GetScriptKeyName ("SelectALink"), ot_help)
		Say(msg11 +; "To reformat the document, use "
		GetScriptKeyName ("ReformatDocument"), ot_help)
		Say(msg12 +; "To go to the first form field on the document, use "
		GetScriptKeyName ("FocusToFirstField"), ot_help)
		return
	EndIf
EndIf
let winHandle = GetAppMainWindow (winHandle)
let theClass = GetWindowClass (winHandle)
if (theClass == wc_MainAppWindow) then
	Say(msg13 +; "To click a button in the toolbar, use "
	GetScriptKeyName ("Toolbar"), ot_help)
EndIf
HotKeyHelpDefaultLoop ()  ; standard dialog boxes
EndScript

Script ScreenSensitiveHelp ()
var
	handle hwnd,
	String TheClass

if (IsSameScript ()) then
	AppFileTopic ()
	return
endif

let hwnd = GetCurrentWindow ()
Let TheClass = GetWindowClass (hwnd)
if (TheClass == ie4Class) then
	if GetHelpWindow () then
		Say(msg14, ot_help); "This is the help topic window "
		Say(msg15, ot_help); "in which you can read the currently loaded document. "
		Say(msg16+ ; "To switch to the left pane in the help window, use " 
				GetScriptKeyName ("NextDocumentWindow") + ". ", ot_help)
		Say(msg17 + ; "To select a page, press "
				GetScriptKeyName ("SelectHelpTab") + ". ", ot_help)
		Say(msg59+; "For more JAWS hotkeys, press " 
				GetScriptKeyName ("HotKeyHelp") + ". ", ot_help)
		return
	EndIf
	Say(msg19, ot_help); "This is the message body window "
	Say(msg20, ot_help); "in which you can read or compose a message. "
	Say(msg21, ot_help); "Press insert plus h to get a list of hot keys "
	return
EndIf
if IsLinksList (hwnd) then
	Say(msg22, ot_help); "This is a list of all the links contained on the current message. "
	Say(msg23, ot_help); "Select a link using the arrow keys or the first letter "
	Say(msg24, ot_help); "and press enter to go to it. "
	return
EndIf
if IsToolbarList (hwnd) then
	Say(msg25, ot_help); "this is a list of the buttons in the Outlook Express toolbar. "
	Say(msg26, ot_help); "Select a button using the arrow keys or the first letter of the label "
	Say(msg27, ot_help); "and hit enter to click on it. "
	return
EndIf
PerformScript ScreenSensitiveHelp ()
EndScript

Int Function IsLinksList (handle hwnd)
if (GetWindowSubtypeCode (hwnd) == wt_listbox) then
	if (GetWindowClass (GetAppMainWindow (hwnd)) == wc_JAWS) then
		if (GetWindowName (GetRealWindow (hwnd)) == SelectALinkDialogName) then
			return 1;
		endIf
	EndIf
EndIf
return 0;
EndFunction

Int Function IsToolbarList (handle hwnd)
if (GetWindowSubtypeCode (hwnd) == wt_listbox) then
	if (GetWindowClass (GetAppMainWindow (hwnd)) == wc_JAWS) then
		if (GetWindowName (GetRealWindow (hwnd)) == ToolbarDialogName) then
			return 1;
		endIf
	EndIf
EndIf
return 0;
EndFunction

HANDLE Function GetToolbar ()
;var
;	handle WinHandle
;let WinHandle = FindDescendantWindow (GetAppMainWindow (GetFocus ()), tool_bar)
;if (winHandle && 
;	GetWindowClass (winHandle) == wc_toolbar) then
;	return winHandle
;EndIf
;return 0
Var
	Handle hAppWin, Handle hFirstChild, Handle hNext,
	Handle hToolParent, Handle hTool
Let hAppWin = GetAppMainWindow (GetFocus ())
If (hAppWin) then
	Let hFirstChild = GetFirstChild (hAppWin)
Else
	Return 0
EndIf
If (hFirstChild) then
	Let hNext = GetNextWindow (hFirstChild)
Else
	Return 0
EndIf
If (hNext) then
	Let hToolParent = FindDescendantWindow (hNext, tool_bar_parent)
Else
	Return 0
EndIf
If (hToolParent) then
	Let hTool = FindDescendantWindow (hToolParent, tool_bar)
	If (!hTool) Then
		Let hTool = FindDescendantWindow (hToolParent, tool_barA)
	EndIf
Else
	Return 0
EndIf
Return hTool
EndFunction

HANDLE Function GetHelpToolbar (handle helpWindow)
var
	handle WinHandle
let WinHandle = FindDescendantWindow (helpWindow, help_tool_bar)
if winHandle then
	if GetWindowClass (winHandle) == wc_toolbar then
		return winHandle
	EndIf
EndIf
return 0
EndFunction

Function HelpToolBar (handle helpWindow)
var
	handle winHandle,
	string firstButton,
	int item
let winHandle = GetHelpToolbar (HelpWindow)
if (!winHandle || !IsWindowVisible (winHandle)) then
	Say(msg_ToolbarNotFound, ot_message)
	return
EndIf
SaveCursor ()
InvisibleCursor ()
MoveToWindow (winHandle)
let firstButton = GetWord ()
RestoreCursor ()
if (firstButton == "Hide") then
	let item = dlgSelectItemInList (strToolbar1, HelpToolbarDialogName, true)
else
	let item = dlgSelectItemInList (strToolbar2, HelpToolbarDialogName, true)
EndIf
let nSuppressEcho = true
delay (2)
if ((item == Hide) && (firstButton == "Hide")) then
	ClickToolBarButton (winHandle, "Hide")
elif ((item == Show) && (firstButton == "Show")) then
	ClickToolBarButton (winHandle, "Show")
elif (item == Back) then
	ClickToolBarButton (winHandle, "Back")
elif (item == helpForward) then
	ClickToolBarButton (winHandle, "Forward")
elif (item == Options) then
	ClickToolBarButton (winHandle, "Options")
elif (item == Web) then
	ClickToolBarButton (winHandle, "Web")
EndIf
let nSuppressEcho = false
EndFunction

Function ClickToolBarButton (handle winHandle, string buttonLabel)
SaveCursor ()
JawsCursor ()
if FindString (winHandle, buttonLabel, s_top, s_restricted) then
	pause ()
	LeftMouseButton ()
else
	Say(buttonLabel + " button not found ", ot_control_name)
EndIf
EndFunction

Script NextMessage () ;Moves to next message within the message window and anounces the from and subject fields prior to reading.
var
	handle hwnd,
	string theClass,
	int verbosity
{Control + .}
	Say(msg_NextMessage, ot_message)
let hwnd = GetFocus ()
Let TheClass = GetWindowClass (hwnd)
if (TheClass == ie4Class) then
	let nSuppressEcho = true
	delay (3)
	let verbosity = GetVerbosity ()
	while (GetVerbosity () != intermediate)
		VerbosityLevel ()
	EndWhile
	PerformScript ReadFromField()
	PerformScript ReadSubjectField()
	while (GetVerbosity () != verbosity)
		VerbosityLevel ()
	EndWhile
	SayWindow (hwnd, read_everything)
	let nSuppressEcho = false
EndIf
EndScript

Script PreviousMessage () ;Reads previous message from within the message Window and anounces the from and subject fieleds prior to reading
var
	handle hwnd,
	string theClass,
	int verbosity
{Control + ,}
Say(msg_PreviousMessage, ot_message)
let hwnd = GetFocus ()
Let TheClass = GetWindowClass (hwnd)
if (TheClass == ie4Class) then
	let nSuppressEcho = true
	delay (3)
	let verbosity = GetVerbosity ()
	while (GetVerbosity () != intermediate)
		VerbosityLevel ()
	EndWhile
	PerformScript ReadFromField()
	PerformScript ReadSubjectField()
	while (GetVerbosity () != verbosity)
		VerbosityLevel ()
	EndWhile
	SayWindow (hwnd, read_everything)
	let nSuppressEcho = false
EndIf
EndScript

Script DeleteMessage () ;Deletes current message from within the message window, reads from and subject fields prior to reading next message.
var
	handle hwnd,
	string theClass,
	int verbosity
Say(msg_DeleteMessage, ot_message)
{control + d}
let nSuppressEcho = true
delay (3)
let hwnd = GetFocus ()
Let TheClass = GetWindowClass (hwnd)
if (TheClass == Ie4Class ) then
	let verbosity = GetVerbosity ()
	while (GetVerbosity () != intermediate)
		VerbosityLevel ()
	EndWhile
	PerformScript ReadFromField()
	PerformScript ReadSubjectField()
	SayWindow (hwnd, read_everything)
	while (GetVerbosity () != verbosity)
		VerbosityLevel ()
	EndWhile
EndIf
let nSuppressEcho = false
EndScript

Script GotoNextUnreadMessage () ;moves to next unread message and anounces from and subject fields prior to reading. 
var
	handle hwnd,
	string theClass,
	int verbosity
Say(msg_GotoNextUnreadMessage, ot_message)
{Control + U}
let hwnd = GetFocus ()
Let TheClass = GetWindowClass (hwnd)
if (TheClass == ie4Class) then
	let nSuppressEcho = true
	delay (3)
	let verbosity = GetVerbosity ()
	while (GetVerbosity () != intermediate)
		VerbosityLevel ()
	EndWhile
	PerformScript ReadFromField()
	PerformScript ReadSubjectField()
	while (GetVerbosity () != verbosity)
		VerbosityLevel ()
	EndWhile
	SayWindow (hwnd, read_everything)
	let nSuppressEcho = false
EndIf
EndScript

Script GotoNextThread () ;moves to next thread. 
var
	handle hwnd,
	string theClass,
	int verbosity
Say(msg_GotoNextThread, ot_message)
{Control + Shift + U}
let hwnd = GetFocus ()
Let TheClass = GetWindowClass (hwnd)
if (TheClass == ie4Class) then
	let nSuppressEcho = true
	delay (3)
	let verbosity = GetVerbosity ()
	while (GetVerbosity () != intermediate)
		VerbosityLevel ()
	EndWhile
	PerformScript ReadFromField()
	PerformScript ReadSubjectField()
	while (GetVerbosity () != verbosity)
		VerbosityLevel ()
	EndWhile
	SayWindow (hwnd, read_everything)
	let nSuppressEcho = false
EndIf
EndScript

Script SayNextLine () ;says subscribed when down arrowing through the listview when in the newsgroup dialog
var
int TheTypeCode
NextLine()
if (IsLeftButtonDown ()) then
SelectingText(TRUE)
pause ()
SelectingText(false)
return
EndIf
if not IsPCCursor () then
SayLine ()
return
EndIf
if (GetWindowTypeCode (GetCurrentWindow ()) == WT_SLIDER) then
SayWord ()
return
EndIf
if (GetWindowTypeCode(GetCurrentWindow()) == WT_TABCONTROL) then
SayWord()
return
EndIf
if CaretVisible () then
SayLine ()
return
EndIf
let TheTypeCode = GetWindowSubtypeCode (GetCurrentWindow())
if ((TheTypeCode == WT_TREEVIEW) ||
(TheTypeCode == WT_MULTISELECT_LISTBOX) ||
(TheTypeCode == WT_EXTENDEDSELECT_LISTBOX)) then
SayLine()
endif
if (TheTypeCode == WT_LISTVIEW) then
if (GetWindowName (GetRealWindow (GetCurrentWindow ())) == "Newsgroups") then
SayLine ()
EndIf
EndIf
EndScript

Script SayPriorLine () ;Says subscribed when up arrowing through the list view in the newsgroup dialog
var
int TheTypeCode
PriorLine()
if (IsLeftButtonDown ()) then
SelectingText(TRUE)
pause ()
SelectingText(false)
return
EndIf
if not IsPCCursor () then
SayLine ()
return
EndIf
if (GetWindowTypeCode (GetCurrentWindow ()) == WT_SLIDER) then
SayWord ()
return
EndIf
if (GetWindowTypeCode(GetCurrentWindow()) == WT_TABCONTROL) then
SayWord()
return
EndIf
if CaretVisible () then
SayLine ()
return
EndIf
let TheTypeCode = GetWindowSubtypeCode (GetCurrentWindow())
if ((TheTypeCode == WT_TREEVIEW) ||
(TheTypeCode == WT_MULTISELECT_LISTBOX) ||
(TheTypeCode == WT_EXTENDEDSELECT_LISTBOX)) then
SayLine()
endif
if (TheTypeCode == WT_LISTVIEW) then
if (GetWindowName (GetRealWindow (GetCurrentWindow ())) == "Newsgroups") then
SayLine ()
EndIf
EndIf
EndScript

HANDLE Function GetHelpWindow ()
var
	handle hwnd
let hwnd = GetTopLevelWindow (GetFocus ())
;if (GetWindowName (hwnd) == wn_help) then
If (StringContains (GetWindowName (hwnd), wn_help)) then
	return hwnd
else
	return 0
EndIf
EndFunction

HANDLE Function GetHelpTabControl (handle helpWindow)
var
	handle winHandle
let winHandle = FindDescendantWindow (helpWindow, help_tab_control)
if winHandle then
	if GetWindowClass (winHandle) == "SysTabControl32" then
		return winHandle
	EndIf
EndIf
return 0
EndFunction

Script SelectHelpTab ()
var
	handle winHandle,
	int item
let winHandle = GetHelpWindow ()
if winHandle then
	let winHandle = GetHelpTabControl (winHandle)
	if (!winHandle || !IsWindowVisible (winHandle)) then
		Say(msg_TabControlNotFound, ot_control_name)
		return
	EndIf
	let item = dlgSelectItemInList (strTabControl, SelectTabDialogName, true)
	let nSuppressEcho = true
	delay (2)
	if (item == Contents) then
	;	{alt + c}
		ClickTab (winHandle, "Contents")
	elif (item == Index) then
	;	{alt + i}
		ClickTab (winHandle, "Index")
	elif (item == Search) then
	;	{alt + s}
		ClickTab (winHandle, "Search")
	EndIf
	let nSuppressEcho = false
else
	Say(msg_NotHelpWindow, ot_message)
EndIf
EndScript

Function ClickTab (handle winHandle, string tab)
SaveCursor ()
JawsCursor ()
if FindString (winHandle, tab, s_top, s_restricted) then
	pause ()
	LeftMouseButton ()
else
	Say(tab + msg_TabNotFound, ot_control_name)
EndIf
EndFunction

HANDLE Function GetContentsTreeView (handle helpWindow)
var
	handle hwnd
let hwnd = GetFirstChild (GetHelpTabControl (helpWindow))
if hwnd then
	if IsWindowVisible (hwnd) then
		if GetWindowClass (hwnd) == "SysTreeview32" then 
			return hwnd
		EndIf
	EndIf
EndIf
return 0
EndFunction

HANDLE Function GetHelpIndexEdit (handle helpWindow)
var
	handle winHandle
let winHandle = FindDescendantWindow (helpWindow, help_index_edit)
if winHandle then
	if IsWindowVisible (winHandle) then
		if GetWindowClass (winHandle) == "Edit" then
			return winHandle
		EndIf
	EndIf
EndIf
return 0
EndFunction

HANDLE Function GetHelpSearchEdit (handle helpWindow)
var
	handle winHandle
let winHandle = FindDescendantWindow (helpWindow, help_search_edit)
if winHandle then
	if IsWindowVisible (winHandle) then
		if GetWindowClass (winHandle) == "Edit" then
			return winHandle
		EndIf
	EndIf
EndIf
return 0
EndFunction

Int Function GetHelpPage (handle helpWindow)
if GetContentsTreeView (helpWindow) then
	return Contents
elif GetHelpIndexEdit (helpWindow) then
	return Index
elif GetHelpSearchEdit (helpWindow) then
	return Search
EndIf
return 0
EndFunction

Script NextDocumentWindow () 
var
	handle helpWindow,
	int page
let helpWindow = GetHelpWindow ()
if helpWindow then
	if GetWindowClass (GetFocus ()) == IE4Class then
		let page = GetHelpPage (helpWindow)
		if (page == Contents) then
			{alt + c}
		elif (page == Index) then
			{alt + i}
		elif (page == Search) then
			{alt + s}
		EndIf
		return
	EndIf
EndIf
{control+tab}
delay (1)
if (IsMultiPageDialog ()) then
	Say(GetDialogPageName (), ot_dialog_name)
	return
endif
EndScript

Script PreviousDocumentWindow() 
var
	handle helpWindow,
	int page
let helpWindow = GetHelpWindow ()
if helpWindow then
	if GetWindowClass (GetFocus ()) == IE4Class then
		let page = GetHelpPage (helpWindow)
		if (page == Contents) then
			{alt + c}
		elif (page == Index) then
			{alt + i}
			{tab}
			{tab}
		elif (page == Search) then
			{alt + s}
			{tab}
			{tab}
			{tab}
		EndIf
		return
	EndIf
EndIf
{control+shift+tab}
Delay (1)
if (IsMultiPageDialog ()) then
	Say(GetDialogPageName (), ot_dialog_name)
	return
endif
EndScript

Script ToolBar ()
var
	handle winHandle,
	int item
let winHandle = GetHelpWindow ()
if winHandle then
	HelpToolBar (winHandle)
	return
EndIf
let winHandle = GetToolbar ()
if (!winHandle || !IsWindowVisible (winHandle)) then
	Say(msg_ToolbarNotFound, ot_message); "Tool bar not found"
	return
EndIf
let item = dlgSelectItemInList (strToolbar, ToolbarDialogName, true)
let nSuppressEcho = true
delay (2)
if (item == Compose) then
	ClickToolBarButton (winHandle, "Compose")
elif (item == Reply) then
	ClickToolBarButton (winHandle, "Reply")
elif (item == ReplyToAll) then
	ClickToolBarButton (winHandle, "Reply to All")
elif (item == Forward) then
	ClickToolBarButton (winHandle, "Forward")
elif (item == Send) then
	ClickToolBarButton (winHandle, "Send")
elif (item == Delete) then
	ClickToolBarButton (winHandle, "Delete")
elif (item == Address) then
	ClickToolBarButton (winHandle, "Address")
EndIf
let nSuppressEcho = false
EndScript